
#ifndef UTILS_H
#define UTILS_H

#include <stdio.h>
#include <time.h>
#include <malloc.h>
#include <memory.h>
#include <string.h>
#include <ctype.h>

#ifdef _WIN32
 #define STRICMP stricmp
 #define STRNICMP _strnicmp
 #define SNPRINTF _snprintf
#else
 #define STRNICMP strncasecmp
 #define STRICMP strcasecmp
 #define SNPRINTF snprintf
#endif

void *         zmalloc       (size_t t);
unsigned char  fpeekc        (FILE *f);
void           mufgets       (char *s, size_t t, FILE *f);
char *         make_string   (const char *s);
char *         escape_quotes (const char *s);
char *         arg_sep       (char *s, char sep);
void           str_tolower   (char *str);
bool           is_false      (const char *x);
bool           is_true       (const char *x);
size_t         intlen        (int x);


#endif

