#include "utils.h"

void * zmalloc(size_t t) {
	void *p = malloc(t);
	memset(p,0,t);
	return p;
}

unsigned char fpeekc(FILE *f) {
	if (!f) return 0;

	unsigned char c = fgetc(f);
	ungetc(c,f);

	return c;
}

void mufgets(char *s, size_t t, FILE *f) {
	for(unsigned int i = 0; i < (t-1); i++) {
		char c = fgetc(f);
		if (c == '\r' || c == '\n') { 
			s[i] = '\0';
			return;
		}
		s[i] = c;
	}
}

char * make_string(const char *s) {
	if (!s) s = "";
	char *p = (char *) zmalloc(strlen(s) + 1);
	strcpy(p,s);
	return p;
}

void str_tolower(char *str) {
	if (!str) return;
	for (char *p = str; *p; p++) {
		if (isupper(*p)) *p = tolower(*p);
	}
}

size_t intlen(int x) {
	size_t size = 0;
	if (x < 0) size++;
	while (x /= 10) size++;
	size++;
	return size;
}

char * escape_quotes(const char *s) {
	int count = 0;
	const char *p = s;
	while (*p) {
		count++;
		if (*p == '\'') count++;
		p++;
	}

	char * newstr = (char *) zmalloc(count + 1);
	char *t = newstr;
	p = s;
	while (*p) {
		if (*p == '\'') { 
			*t++ = '\\'; 
			*t++ = '\'';
			p++;
		} else {
			*t++ = *p++;
		}
	}
	return newstr;

}

char * arg_sep(char *x, char sep) {
	char *p = x;
	while (*p) {
		if (*p == sep) {
			*p = '\0';
			p++;
			return p;
		}
		p++;
	}

	return 0;
}

bool is_false(const char *x) { return (!is_true(x)); }

bool is_true(const char *x) {
	if (!x) return false;
	if (x[0] == 'T' || x[0] == 't' || x[0] == '1') return true;
	return false;
}
