
#include <time.h>
#include <stdlib.h>
#include "utils.h"
#include "timing.h"
#include "cmfx.h"
#include "db_gen.h"

time_t last_clean = 0;
time_t clean_time = 0;

int timing_init() {
   const char *cleanstr = cmfx_get_var("CLEANTIME");
   clean_time = (cleanstr ? atoi(cleanstr) : TIMING_DEFCLEAN);
   
   return 0;
}

void timing_cleanup() {
   return;
}

void timing_dispatch_event() {
   time_t now = time(NULL);
   // Did a clean operation happen?
   if (last_clean + clean_time <= now) {
      db_gen_clean_cache();
      last_clean = now;
   }
}

time_t timing_next_event_time() {

   time_t now = time(NULL);
   time_t greatest_time = now + TIMING_MAXACTIONTIME;

   // Check to see if objects need to be cleaned
   time_t next_clean = last_clean + clean_time;
   if (next_clean <= greatest_time) greatest_time = next_clean;
	
	return greatest_time;
}
