#ifndef SOCKETS_H
#define SOCKETS_H

#include "db_gen.h"

// Defines for all platforms
#define SOCK_DEFAULTWAIT 5
#define MAX_RECV  4096
#define MAX_SEND 4096


#ifdef _WIN32
 #define SOCKTYPE SOCKET
 #define SOCKCLOSE closesocket
 #define SOCKRECV recv
 #define SOCKSEND send
 #define SELECT_ERROR SOCKET_ERROR
 #define ACCEPT_ERROR SOCKET_ERROR
 #define STAT _stat
 #define STATSTRUCT _stat

 #include <winsock2.h>
 #include <windows.h>
 #include <stdio.h>
 #include <time.h>
 #include <sys/stat.h>

#else
 #include <stdio.h>
 #include <sys/types.h>
 #include <sys/socket.h>
 #include <netinet/in.h>
 #include <errno.h>
 #include <unistd.h>
 #include <fcntl.h>
 #include <string.h>
 #include <iostream.h>
 #include <stdlib.h>
 #include <ctype.h>
 #include <time.h>
 #include <netdb.h>
 #include <sys/time.h>
 #include <sys/stat.h>

 #define SOCKTYPE      int
 #define SOCKCLOSE     close
 #define SOCKRECV      recv
 #define SOCKSEND      send
 #define STAT          stat
 #define STATSTRUCT    stat
 #define SELECT_ERROR  -1
 #define ACCEPT_ERROR  -1

#endif


#define STATUS_WELCOMED 1
#define STATUS_GOTUSER  2
#define STATUS_LOGGEDIN 3

typedef struct inLinesTAG {
	char *line;
	inLinesTAG *next;
} inLines;

typedef struct descrdataTAG {
	SOCKTYPE descr;
	unsigned int conn;
	inLines *commands;
	char *outbuf;
	char *outbufend;
	char *inbuf;
	char *inbufend;
	char hostname[128];
	int  status;
	int  boot;
	DATA_OBJ *user;
	struct descrdataTAG *next;
} descrdata;


int            sock_init             ();
int            sock_cleanup          ();
int            sock_handle           ();
void           sock_addline          (descrdata *s, char *str);
int            sock_procin           (descrdata *s);
int            sock_procout          (descrdata *s);
descrdata *    sock_find_by_descr    (SOCKTYPE descr);
descrdata *    sock_find_by_conn     (unsigned int conn);
descrdata *    sock_find_by_vnum     (int vnum);
descrdata *    sock_find_by_name     (const char *name);
int            sock_make_socket      (int port);
void           sock_new_conn         (int p, SOCKTYPE s);
void           sock_write            (descrdata *s, const char *str);
void           sock_welcome          (descrdata *s);
void           sock_goodbye          (descrdata *s);
descrdata *    sock_remember_descr   (SOCKTYPE s, char hostname[128]);
void           sock_forget_descr     (SOCKTYPE sock);
char *         sock_addrout          (int lport, long a, unsigned short prt);

// TODO: No one else should want to mess with these. If that's the case, a new sock function
// is needed.
extern descrdata *sockets;

#endif