
#ifndef OBJECTS_H
#define OBJECT_H

DATA_OBJ * obj_match(DATA_OBJ *self, const char *name, bool env = false, int mnum = 1);
DATA_OBJ * obj_find_action(DATA_OBJ *self, const char *name);
char *     obj_unmangle(DATA_OBJ *obj);
bool       obj_recycle(DATA_OBJ *obj);
bool       obj_is_obj(DATA_OBJ *obj);
bool       obj_is_pc(DATA_OBJ *obj);
bool       obj_is_npc(DATA_OBJ *obj);
bool       obj_is_room(DATA_OBJ *obj);
bool       obj_is_action(DATA_OBJ *obj);
bool       obj_is_script(DATA_OBJ *obj);
bool       obj_is_garbage(DATA_OBJ *obj);

#define OBJ_TYPE_OBJ       0x00000000
#define OBJ_TYPE_PC        0x00000001
#define OBJ_TYPE_NPC       0x00000002
#define OBJ_TYPE_ROOM      0x00000004
#define OBJ_TYPE_ACTION    0x00000008
#define OBJ_TYPE_SCRIPT    0x00000010
#define OBJ_TYPE_GARBAGE   0x00000020
#define OBJ_TYPE_MASTER    0x00000040
#define OBJ_TYPE_SLAVE     0x00000080
#define OBJ_TYPE_BUILDER   0x00000100
#define OBJ_TYPE_LINKABLE  0x00000200
#define OBJ_TYPE_OWNABLE   0x00000400
#define OBJ_TYPE_DARK      0x00000800
#define OBJ_TYPE_KILLABLE  0x00001000
#define OBJ_TYPE_RESPAWN   0x00002000

#define OBJ_TYPE_MASK      0x0000003F

#endif