
#include "cmfx.h"
#include "utils.h"
#include "db_mysql.h"
#include "db_gen.h"
#include "objects.h"
#include "actions.h"
#include "logging.h"
#include "comm.h"
#include "commands.h"


// Big ugly search for objects.
// First, if 'self' is an object, look at my contents. Then check the exits on those
// contents. After checking the exits, then look at the contents in the room, then
// the exits of the contents, and finally the exits of the room. If env is true, then
// move up the room environment chain and repeat. If 'self' is a room, then just start
// out immediately at the contents of the room section.
DATA_OBJ * obj_match(DATA_OBJ *self, const char *name, bool env, int mnum) {

	if (!self) return 0;
	if (!name) return 0;

	// Database lookup
	if (name[0] == '#') {
		int vnum = atoi(name + 1);
		return db_gen_load_obj(vnum);
	}

	// If we're looking for myself
	if (!STRICMP(name,"me")) {
		if (self->flags & 0x00000001 || self->flags & 0x00000002)
			return self;

		return 0;
	}

	// If we're looking for my location
	if (!STRICMP(name,"here")) {
		if (self->flags & 0x00000001 || self->flags & 0x00000002) {
			return db_gen_load_obj(self->location);
		}

		return 0;
	}

	char *prefix = make_string(name);

	char *locname = arg_sep(prefix,'.');
	int match_num = (prefix == 0 ? 1 : atoi(prefix));	
	if (!locname) {
	   locname = prefix;
	}
	if (match_num == 0) match_num = 1;

	// Object is a room
	if (self->flags & OBJ_TYPE_ROOM) {
		// First, check the room contents
		OBJECT_CHAIN *self_head = db_gen_get_contents(self);
		OBJECT_CHAIN *self_oc = self_head;
		int curr_num = mnum;
		while (self_oc) {
			if (!STRNICMP(locname,self_oc->obj->name,strlen(locname))) {
				if (curr_num == match_num) {
					DATA_OBJ *obj = self_oc->obj;
					db_gen_free_obj_chain(self_head);
					free(prefix);					
					return obj;
				}
				curr_num++;
			}
			self_oc = self_oc->next;
		}

		// Now check the exits of the contents on the room
		self_oc = self_head;
		while (self_oc) {
			if (self_oc->obj->exits != -1) {
				DATA_OBJ *dob = db_gen_load_obj(self_oc->obj->exits);
				OBJECT_CHAIN *exits_head = db_gen_get_exits(dob);
				OBJECT_CHAIN *exits_oc = exits_head;
				while (exits_oc) {
					if (!STRNICMP(locname,exits_oc->obj->name,strlen(locname))) {
						if (curr_num == match_num) {
							DATA_OBJ *obj = exits_oc->obj;
							db_gen_free_obj_chain(self_head);							
							db_gen_free_obj_chain(exits_head);
							free(prefix);
							return obj;
						}
						curr_num++;
					}
					exits_oc = exits_oc->next;
				}
			}
			self_oc = self_oc->next;
		}
		db_gen_free_obj_chain(self_head);

		// Now look for the exits on the room
		self_head = db_gen_get_exits(self);
		self_oc = self_head;
		while (self_oc) {
			if (!STRNICMP(locname,self_oc->obj->name,strlen(locname))) {
				if (curr_num == match_num) {
					DATA_OBJ *obj = self_oc->obj;
					db_gen_free_obj_chain(self_head);
					free(prefix);					
					return obj;
				}
				curr_num++;
			}
			self_oc = self_oc->next;
		}
		db_gen_free_obj_chain(self_head);

		// We didn't find anything. So, do we check the environment up?
		if (!env) return 0;
		if (self->parent == -1) return 0;
		DATA_OBJ *parent = db_gen_load_obj(self->parent);
		free(prefix);		
		return obj_match(parent,name,env,curr_num);
		
	} else {

		// First, make sure that I don't have it in my contents.
		OBJECT_CHAIN *self_head = db_gen_get_contents(self);
		OBJECT_CHAIN *self_oc = self_head;
		int curr_num = mnum;
		while (self_oc) {
			if (!STRNICMP(locname,self_oc->obj->name,strlen(locname))) {
				if (curr_num == match_num) {
					DATA_OBJ *obj = self_oc->obj;
					db_gen_free_obj_chain(self_head);
					free(prefix);					
					return obj;
				}
				curr_num++;
			}
			self_oc = self_oc->next;
		}

		// Now check the exits of the contents on myself
		self_oc = self_head;
		while (self_oc) {
			if (self_oc->obj->exits != -1) {
				DATA_OBJ *dob = db_gen_load_obj(self_oc->obj->exits);
				OBJECT_CHAIN *exits_head = db_gen_get_exits(dob);
				OBJECT_CHAIN *exits_oc = exits_head;
				while (exits_oc) {
					if (!STRNICMP(locname,exits_oc->obj->name,strlen(locname))) {
						if (curr_num == match_num) {
							DATA_OBJ *obj = exits_oc->obj;
							db_gen_free_obj_chain(self_head);							
							db_gen_free_obj_chain(exits_head);
							free(prefix);							
							return obj;
						}
						curr_num++;
					}
					exits_oc = exits_oc->next;
				}
			}
			self_oc = self_oc->next;
		}
		db_gen_free_obj_chain(self_head);

		// Exits on myself are handled by the check for exits on the objects in the room :>

		// Then recursively check the room and its exists
		DATA_OBJ *loc = db_gen_load_obj(self->location);
		free(prefix);		
		return obj_match(loc,name,env,curr_num);
	}

	return 0;

}

DATA_OBJ * obj_find_action(DATA_OBJ *self, const char *name) {

	if (!self) return 0;
	if (!name) return 0;

	// Object is a room
	if (self->flags & 0x00000004) {
		// Check the exits on the current room
		OBJECT_CHAIN *self_head = db_gen_get_exits(self);
		OBJECT_CHAIN *self_oc = self_head;
		while (self_oc) {
			if (!STRNICMP(name,self_oc->obj->name,strlen(name))) {
				DATA_OBJ *obj = self_oc->obj;
				db_gen_free_obj_chain(self_head);
				return obj;
			}
			self_oc = self_oc->next;
		}
		db_gen_free_obj_chain(self_head);
		
      // Nothing in the current room, check up a level in the environment
		if (self->parent == -1) return 0;
		DATA_OBJ *parent = db_gen_load_obj(self->parent);
		obj_find_action(parent,name);
	} else {
		// First, check exits on myself.
		OBJECT_CHAIN *self_head = db_gen_get_exits(self);
		OBJECT_CHAIN *self_oc = self_head;
		while (self_oc) {
			if (!STRNICMP(name,self_oc->obj->name,strlen(name))) {
				DATA_OBJ *obj = self_oc->obj;
				db_gen_free_obj_chain(self_head);
				return obj;
			}
			self_oc = self_oc->next;
		}
		db_gen_free_obj_chain(self_head);
		
		// Check exits of my contents
		self_head = db_gen_get_contents(self);
		self_oc = self_head;
		while (self_oc) {
			if (self_oc->obj->exits != -1) {
				DATA_OBJ *dob = db_gen_load_obj(self_oc->obj->exits);
				OBJECT_CHAIN *exits_head = db_gen_get_exits(dob);
				OBJECT_CHAIN *exits_oc = exits_head;
				while (exits_oc) {
					if (!STRNICMP(name,exits_oc->obj->name,strlen(name))) {
						DATA_OBJ *obj = exits_oc->obj;
						db_gen_free_obj_chain(self_head);							
						db_gen_free_obj_chain(exits_head);
						return obj;
					}
					exits_oc = exits_oc->next;
				}
			}
			self_oc = self_oc->next;
		}
		db_gen_free_obj_chain(self_head);
		
		
   	// Finally, check the exits on the OBJECTS in the current room
   	// meaning that exits on a person, or other thing can't be run for
   	// security reasons
   	DATA_OBJ *here = db_gen_load_obj(self->location);
		self_head = db_gen_get_contents(here);
		self_oc = self_head;
		while (self_oc) {
			if (self_oc->obj->exits != -1 && obj_is_obj(self_oc->obj)) {
				DATA_OBJ *dob = db_gen_load_obj(self_oc->obj->exits);
				OBJECT_CHAIN *exits_head = db_gen_get_exits(dob);
				OBJECT_CHAIN *exits_oc = exits_head;
				while (exits_oc) {
					if (!STRNICMP(name,exits_oc->obj->name,strlen(name))) {
						DATA_OBJ *obj = exits_oc->obj;
						db_gen_free_obj_chain(exits_head);
						return obj;
					}
					exits_oc = exits_oc->next;
				}
			}
			self_oc = self_oc->next;
		}
		db_gen_free_obj_chain(self_head);
	
	   // If we got here, then we need to check the room and up the environment
	   // call ourselves with the location of the room and we should be good to go.
	   
		return obj_find_action(here,name);	   

	}

	return 0;
}

// Objects have no type flag
bool obj_is_obj(DATA_OBJ *obj) {
   if (obj->flags & OBJ_TYPE_MASK) return false;
   return true;
}

bool obj_is_pc(DATA_OBJ *obj) {
   if (obj->flags & OBJ_TYPE_PC) return true;
   return false;
}

bool obj_is_npc(DATA_OBJ *obj) {
   if (obj->flags & OBJ_TYPE_NPC) return true;
   return false;
}


bool obj_is_room(DATA_OBJ *obj) {
   if (obj->flags & OBJ_TYPE_ROOM) return true;
   return false;
}

bool obj_is_action(DATA_OBJ *obj) {
   if (obj->flags & OBJ_TYPE_ACTION) return true;
   return false;
}

bool obj_is_script(DATA_OBJ *obj) {
   if (obj->flags & OBJ_TYPE_SCRIPT) return true;
   return false;
}

bool obj_is_garbage(DATA_OBJ *obj) {
   if (obj->flags & OBJ_TYPE_GARBAGE) return true;
   return false;
}






bool obj_recycle(DATA_OBJ *obj) {
	// Sanity checking
	if (!obj) return false;
	if (obj->vnum == 0 || obj->vnum == 1) return false;

	// *************** TODO ******************************************************
	// BEFORE removing any objects at all, make sure to remove their 'listeners'
	// from the database
	// ***************************************************************************

	// To recycle an action, remove it from the 'exits' chain of the object it's on
	// and then remove the object. 
	if (obj->flags & OBJ_TYPE_ACTION) {
		// If the object isn't located on anything, there's some DB corruption, alert but continue happy
		if (obj->location != -1) {
			DATA_OBJ *location = db_gen_load_obj(obj->location);
			// If the location chain, we claim to be on doesn't exist, there's some
			if (location->exits != -1) {
				DATA_OBJ *prev_exit = 0;
				DATA_OBJ *curr_exit = db_gen_load_obj(location->exits);
				while (curr_exit) {
					if (curr_exit->vnum == obj->vnum) {
						// We've found a match, remove it from the chain
						if (prev_exit) {
							prev_exit->next = curr_exit->next;
						} else {
							location->exits = curr_exit->next;
						}

						db_gen_recycle_obj(obj);

						return true;
					}
					prev_exit = curr_exit;
					if (curr_exit->next == -1) curr_exit = 0;
					else curr_exit = db_gen_load_obj(curr_exit->next);
				}
			} else {
				log_log(LOG_ERROR, "[OBJ ] ERROR: Action %d was removed from a location with no exits.\r\n", obj->vnum);
			}
		} else {
			log_log(LOG_ERROR, "[OBJ ] ERROR: Action %d was removed with no location.\r\n", obj->vnum);
		}

		return true;

	// To recycle a script, remove it from the contents chain of the object it's in,
	// and then remove the object
	} else if (obj->flags & OBJ_TYPE_SCRIPT) {

		// If the object isn't located on anything, there's some DB corruption, alert but continue happy
		if (obj->location != -1) {
			DATA_OBJ *location = db_gen_load_obj(obj->location);
			// If the contents chain we claim to be on doesn't exist, there's some corruption
			if (location->contents != -1) {
				DATA_OBJ *prev_obj = 0;
				DATA_OBJ *curr_obj = db_gen_load_obj(location->contents);
				while (curr_obj) {
					if (curr_obj->vnum == obj->vnum) {
						// We've found a match, remove it from the chain
						if (prev_obj) {
							prev_obj->next = curr_obj->next;
						} else {
							location->exits = curr_obj->next;
						}

						db_gen_recycle_obj(obj);

						return true;
					}
					prev_obj = curr_obj;
					if (curr_obj->next == -1) curr_obj = 0;
					else curr_obj = db_gen_load_obj(curr_obj->next);
				}
			} else {
				log_log(LOG_ERROR, "[OBJ ] ERROR: Object %d was removed from a location with no contents.\r\n", obj->vnum);
			}
		} else {
			log_log(LOG_ERROR, "[OBJ ] ERROR: Object %d was removed with no location.\r\n", obj->vnum);
		}

		return true;

	// To recycle an object, remove it from the contents chain of the container, and
	// then remove the object
	} else if (!(obj->flags & OBJ_TYPE_MASK)) {

		// If the object isn't located on anything, there's some DB corruption, alert but continue happy
		if (obj->location != -1) {
			DATA_OBJ *location = db_gen_load_obj(obj->location);
			// If the contents chain we claim to be on doesn't exist, there's some corruption
			if (location->contents != -1) {
				DATA_OBJ *prev_obj = 0;
				DATA_OBJ *curr_obj = db_gen_load_obj(location->contents);
				while (curr_obj) {
					if (curr_obj->vnum == obj->vnum) {
						// We've found a match, remove it from the chain
						if (prev_obj) {
							prev_obj->next = curr_obj->next;
						} else {
							location->exits = curr_obj->next;
						}

						db_gen_recycle_obj(obj);

						return true;
					}
					prev_obj = curr_obj;
					if (curr_obj->next == -1) curr_obj = 0;
					else curr_obj = db_gen_load_obj(curr_obj->next);
				}
			} else {
				log_log(LOG_ERROR, "[OBJ ] ERROR: Object %d was removed from a location with no contents.\r\n", obj->vnum);
			}
		} else {
			log_log(LOG_ERROR, "[OBJ ] ERROR: Object %d was removed with no location.\r\n", obj->vnum);
		}

		return true;


	// To recycle a room, first move all contents to their homes. If this is their home,
	// send them to player start. Next, remove all exits from this room by recycling them.
	// Lastly, search the ENTIRE database and set any exits that point to here to now
	// point to nothing. 
	} else if (obj->flags & OBJ_TYPE_ROOM) {

		// First, send everything home, or move it to a new home (the parent room)
		OBJECT_CHAIN *oc_head = db_gen_get_contents(obj);
		OBJECT_CHAIN *oc_curr = oc_head;
		while (oc_curr) {
			if (oc_curr->obj) {
				DATA_OBJ *curr = oc_curr->obj;
				comm_send(curr, "You feel a wrenching sensation as the world tumbles out from under you...");
				if (curr->home != obj->vnum) {
					act_move(curr, db_gen_load_obj(curr->home));
				} else {
					act_move(curr, db_gen_load_obj(obj->parent));
					curr->home = obj->parent;
				}
				if (obj_is_pc(curr) || obj_is_npc(curr)) cmd_look(curr, 0);
			}
			oc_curr = oc_curr->next;
		}
		db_gen_free_obj_chain(oc_head);

		// Next, remove all exits from this room (recycle them)
		oc_head = db_gen_get_exits(obj);
		oc_curr = oc_head;
		while (oc_curr) {
			if (oc_curr->obj) {
				DATA_OBJ *curr = oc_curr->obj;

				// We can recycle these exits directly, instead of de-linking them, as they
				// are all going into limbo
				db_gen_recycle_obj(curr);
			}

			oc_curr = oc_curr->next;
		}
		db_gen_free_obj_chain(oc_head);

		// Finally, were at the difficult part. We need to search the entire database and make any
		// exits that point here point to -1 (unlinked). And any room that has us as a parent needs
		// to be updated to point to the next item up the chain. And finally, any object with this as
		// its home, needs a new home.
		oc_head = db_gen_get_database();
		oc_curr = oc_head;
		while (oc_curr) {
			DATA_OBJ *curr = oc_curr->obj;
			if (curr) {
				if (curr->flags & OBJ_TYPE_GARBAGE) {
					oc_curr = oc_curr->next;
					continue;
				}

				// If the database object has the object to be recycled as its parent, we need
				// to move its parent up in the environment chain. Because we're removing a
				// room, our parent will be a room as well. And anyone who has a room as
				// a parent, has to be a room.
				if (curr->parent == obj->vnum) {
					curr->parent = obj->parent;
				}

				// If the database object has this object set to its home, we need to move
				// it's home up the chain one.
				if (curr->home == obj->vnum) {
					curr->home = obj->parent;
				}

				// If the db object has this set as its exit, we reset the link to -1
				// (The exits chain is either the destination of an exit, or the first action
				//  in a room. Because we're removing a room, the only time this is true is
				//  if an exit is pointing to a room, hence why we reset it).
				if (curr->exits == obj->vnum) {
					curr->exits = -1;
				}
			}

			oc_curr = oc_curr->next;
		}

		// Alright, everything has been updated and we're ready to recycle this object. PHEW!
		db_gen_recycle_obj(obj);
		return true;
	}

	return false;
	
}

char * obj_unmangle(DATA_OBJ *obj) {
   char *buf = (char *) zmalloc(2048);
   SNPRINTF(buf,2047,"%s [#%d] ",obj->name,obj->vnum);
   
   if (obj->flags & 0x00000001) {
      strcat(buf,"PCMob ");
   } else if (obj->flags & 0x00000002) {
      strcat(buf,"NPCMob ");
   } else if (obj->flags & 0x00000004) {
      strcat(buf,"Room ");
   } else if (obj->flags & 0x00000008) {
      strcat(buf,"Action ");
   } else if (obj->flags & 0x00000010) {
      strcat(buf,"Script ");
   } else if (obj->flags & 0x00000020) {
      strcat(buf,"Garbage ");
   } else {
      strcat(buf,"Object ");
   }
   
   if (obj->flags & 0x00000040) strcat(buf,"Master ");
   if (obj->flags & 0x00000080) strcat(buf,"Slave ");
   if (obj->flags & 0x00000100) strcat(buf,"Builder ");
   if (obj->flags & 0x00000200) strcat(buf,"Linkable ");
   if (obj->flags & 0x00000400) strcat(buf,"Chownable ");
   if (obj->flags & 0x00000800) strcat(buf,"Dark ");
   if (obj->flags & 0x00001000) strcat(buf,"Killable ");
   if (obj->flags & 0x00002000) strcat(buf,"Respawn ");
   
   return buf;
   
}