
#include "cmfx.h"
#include "utils.h"
#include "logging.h"

FILE        *logfile   = 0;
int         is_debugged = 0;
int         is_logging = 1;
int         is_quiet   = 0;


int log_init() {

	if (is_true(cmfx_get_var("DEBUG")))   is_debugged = 1;
	if (is_true(cmfx_get_var("NOLOG")))   is_logging  = 0;
	if (is_true(cmfx_get_var("QUIET")))   is_quiet    = 1;

	const char *lfile = cmfx_get_var("LOGFILE");
	if (lfile) logfile = fopen(lfile,"a+b"); else logfile = fopen("core.log","a+b");

	if (logfile && is_logging) {
		char datestr[17];
		time_t tt = time(NULL);
		strftime(datestr,17,"%m/%d/%Y %H:%M",localtime(&tt));
		fprintf(logfile,"---------------------[ %s ]---------------------\r\n",datestr);
	}

	if (!logfile) is_logging = 0;

	return 0;

}

void log_log(unsigned int flags, const char *msg, ...) {
	va_list argp;
	va_start(argp,msg);
	const char *p = msg;
	char *s;
	int  d;

	if (flags == LOG_DEBUG && !is_debugged) return;

	while (*p) {
		if (*p != '%') {
			if (is_logging && logfile) fprintf(logfile,"%c",*p);
			if (!is_quiet)  printf("%c",*p);
			p++;
			continue;
		}
		switch(*(++p)) {
			case 'd':
				d = va_arg(argp,int);
				if (is_logging && logfile) fprintf(logfile,"%d",d);
				if (!is_quiet)  printf("%d",d);
				break;

			case 's':
				s = va_arg(argp,char *);
				if (is_logging && logfile) fprintf(logfile,"%s",s);
				if (!is_quiet)  printf("%s",s);
				break;

			case 'x':
				d = va_arg(argp,int);
				if (is_logging && logfile) fprintf(logfile,"%x",d);
				if (!is_quiet)  printf("%x",d);
				break;

			case '%':
				if (is_logging && logfile) fprintf(logfile,"%c",'%');
				if (!is_quiet)  printf("%c",'%');
		}
		p++;
	}
	va_end(argp);

	fflush(logfile);
}
