#ifndef DB_GEN_H
#define DB_GEN_H

#include <time.h>

#define DB_DEFMAXAGE 1800 // 30 minutes

typedef struct propertyTag {
	char *value;
	char *property;
} PROPERTY;

typedef struct propertyListTag {
	PROPERTY *prop;
	propertyListTag *next;
} PROP_LIST;

typedef struct dataObjTag {
	int vnum;
	char name[256];
	unsigned long flags;
	unsigned short security;
	int parent;
	int spawntime;
	int location;
	int home;
	int owner;
	int value;
	unsigned long created;
	unsigned long modified;
	int contents;
	int exits;
	int next;
	PROP_LIST *props;
} DATA_OBJ;

typedef struct cacheObjTag {
	DATA_OBJ *obj;
	struct cacheObjTag *next;
	time_t cache_time;
	time_t accessed_time;
} CACHE_OBJ;

typedef struct objectChain {
	DATA_OBJ *obj;
	struct objectChain *next;
} OBJECT_CHAIN;



int            db_gen_init            ();
void           db_gen_cleanup         ();
void           db_gen_flush_cache     ();
void           db_gen_clean_cache     ();
void           db_gen_cache_obj       (DATA_OBJ *obj);
void           db_gen_free_obj        (DATA_OBJ *obj);
void           db_gen_free_property   (PROPERTY *p);
void           db_gen_save_obj        (DATA_OBJ *obj);
void           db_gen_add_property    (DATA_OBJ *obj, const char *prop, const char *value);
void           db_gen_add_property    (DATA_OBJ *obj, PROPERTY *p);
void           db_gen_free_obj_chain  (OBJECT_CHAIN *oc);
void           db_gen_del_property    (DATA_OBJ *obj, const char *prop);
void           db_gen_recycle_obj     (DATA_OBJ *obj);
DATA_OBJ *     db_gen_get_cache_obj   (int vnum);
DATA_OBJ *     db_gen_load_obj        (int vnum);
DATA_OBJ *     db_gen_load_pc_name    (const char *name);
DATA_OBJ *     db_gen_get_cache_name  (const char *name);
DATA_OBJ *     db_gen_create_obj      (const char *name);
PROPERTY *     db_gen_get_property    (DATA_OBJ *obj, const char *prop);
PROP_LIST *    db_gen_copy_prop_list  (PROP_LIST *prop_list);
OBJECT_CHAIN * db_gen_get_contents    (DATA_OBJ *obj);
OBJECT_CHAIN * db_gen_get_exits       (DATA_OBJ *obj);
OBJECT_CHAIN * db_gen_get_database    ();


extern int db_top;


#endif