#include "cmfx.h"
#include "sockets.h"
#include "utils.h"
#include "logging.h"
#include "db_gen.h"
#include "timing.h"

vars        *cmdvars = 0;
int          run     = STATUS_RUNNING;

void cmfx_cleanup() {
}

void cmfx_shutdown() {
	run = STATUS_STOP;
}

int main(int argc, char **argv) {

	// Parse out the command line
	for (int i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			if (argv[i][1] == 'D' || argv[i][1] == 'd') {
				char *var = argv[i] + 2;
				cmfx_split_var(var);
			}
		}
	}

	log_log(LOG_NOTICE,"[CORE] NOTICE: Starting up.\r\n");

	if (log_init()) return -1;
	if (sock_init()) return -1;
	if (db_gen_init()) return -1;
	if (timing_init()) return -1;

	while (run == STATUS_RUNNING) {

		timing_dispatch_event();
		if (sock_handle()) break;
	}
	
	log_log(LOG_NOTICE,"[CORE] NOTICE: Cleaning up.\r\n");

   timing_cleanup();
	sock_cleanup();
	cmfx_cleanup();
	db_gen_flush_cache();
	db_gen_cleanup();

	log_log(LOG_NOTICE,"[CORE] NOTICE: Exiting.\r\n");

	return 0;
}

const char * cmfx_get_var(const char *var) {
	if (!cmdvars) return 0;
	if (!var) return 0;

	vars *c = cmdvars;
	while (c) {
		int lex = strcmp(c->varName,var);
		if (!lex) {
			return c->value;
		} else if (lex > 0) {
			return 0;
		}
		c = c->next;
	}

	return 0;
}

void cmfx_add_var(const char *arg, const char *value) {

	if (!arg) return;
	if (!value) return;

	vars *c = cmdvars;
	vars *p = 0;

	while (c) {
		int lex = strcmp(c->varName,arg);
		if (!lex) {
			free(c->value);
			c->value = (char *) zmalloc(strlen(value) + 1);
			strcpy(c->value,value);
			return;
		} else if (lex > 0) {
			vars *x = (vars *) zmalloc(sizeof(vars));
			x->next = c;
			if (!p) {
			   cmdvars = x;
			} else {
			   p->next = x;
			}
			x->varName = (char *) zmalloc(strlen(arg) + 1);
			strcpy(x->varName,arg);
			x->value = (char *) zmalloc(strlen(value) + 1);
			strcpy(x->value, value);
			return;
		}
		p = c;
		c = c->next;
	}

	if (!p) {
		cmdvars = (vars *) zmalloc(sizeof(vars));
		cmdvars->varName = (char *) zmalloc(strlen(arg) + 1);
		strcpy(cmdvars->varName,arg);
		cmdvars->value = (char *) zmalloc(strlen(value) + 1);
		strcpy(cmdvars->value, value);
		return;
	}

	vars *x = (vars *) zmalloc(sizeof(vars));
	x->next = 0;
	p->next = x;
	x->varName = (char *) zmalloc(strlen(arg) + 1);
	strcpy(x->varName,arg);
	x->value = (char *) zmalloc(strlen(value) + 1);
	strcpy(x->value, value);

}


void cmfx_split_var(char *str) {
	char *p = str;
	int got = 0;
	while (*p) {
		if (*p == '=') {
			got = 1;
			*p = '\0';
			break;
		}
		p++;
	}
	if (!got) {
		cmfx_add_var(str,"true");
		return;
	}

	if (!(*(++p))) return;
	cmfx_add_var(str,p);
}
