
#include "db_gen.h"
#include "logging.h"
#include "sockets.h"
#include "timing.h"
#include "utils.h"
#include "cmfx.h"
#include "objects.h"
#include "commands.h"
#include "actions.h"
#include "comm.h"


bool act_move(DATA_OBJ *mob, DATA_OBJ *dest) {

   // Sanity checks
   if (!mob || !dest) return false;
   if ((!obj_is_pc(mob) && !obj_is_npc(mob)) || !obj_is_room(dest)) return false;
   if (obj_is_garbage(dest)) return false;
   
   // TODO: Enqueue every program in the depart queue to run. When one returns
   //       false, abort the sequence. If all return true, then proceed
   // TODO: Check security levels on destination to make sure we can enter it
   // TODO: Enqueue arrive programs. Ignore all return values.
   
   // First, unlink the mob from the old contents chain
   DATA_OBJ *curr = db_gen_load_obj(mob->location);
   if (curr->contents == mob->vnum) {
      curr->contents = mob->next;
      mob->next = -1;
   } else {
      curr = db_gen_load_obj(curr->contents);
      while (curr) {
         if (curr->next == mob->vnum) {
            curr->next = mob->next;
            mob->next = -1;
            break;
         }
         curr = db_gen_load_obj(curr->next);
      }
      if (!curr) {
         log_log(LOG_ERROR,"[ACT ] ERROR: Cannot find object %d in contents chain when departing.\r\n",mob->vnum);
         comm_send(mob,"***ERRROR*** You are an orphan!\r\n");
         return false;
      }
   }
   
   // Now we need to put the mob into the contents chain of the destination room.
   mob->next = dest->contents;
   mob->location = dest->vnum;
   dest->contents = mob->vnum;

   return true;

}